/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWSession;
import filenet.vw.apps.manager.IVWChunkableQuery;
import filenet.vw.apps.manager.IVWDefinableQuery;
import filenet.vw.apps.manager.IVWFolderOpenListener;
import filenet.vw.apps.manager.IVWFolderSelectionListener;
import filenet.vw.apps.manager.IVWItemSelectionListener;
import filenet.vw.apps.manager.IVWMilestonesSelectionListener;
import filenet.vw.apps.manager.IVWQueueSelectionListener;
import filenet.vw.apps.manager.VWFolder;
import filenet.vw.apps.manager.VWFolderOpenEvent;
import filenet.vw.apps.manager.VWFolderSelectionEvent;
import filenet.vw.apps.manager.VWFolderTableModel;
import filenet.vw.apps.manager.VWIconCellRenderer;
import filenet.vw.apps.manager.VWItemSelectionEvent;
import filenet.vw.apps.manager.VWMilestonesSelectionEvent;
import filenet.vw.apps.manager.VWMilestonesTableModel;
import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.VWQueueSelectionEvent;
import filenet.vw.apps.manager.VWQueueTableModel;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.IVWPerformSearchListener;
import filenet.vw.toolkit.utils.query.VWPerformSearchEvent;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWWorkflowManagerItemPane
extends JPanel
implements IVWFolderSelectionListener,
IVWQueueSelectionListener,
IVWMilestonesSelectionListener,
ListSelectionListener,
IVWMouseActionListener,
IVWPerformSearchListener,
IVWFolderOpenListener,
TableModelListener {
    private VWTable m_contentsTable = null;
    private JScrollPane m_scrollPane = null;
    private VWSession m_vwSession = null;
    private int m_modelType = 0;
    private EventListenerList m_itemListenerList = null;
    private EventListenerList m_folderOpenListenerList = null;
    private Container m_parentContainer = null;
    private JApplet m_parentApplet = null;
    private VWNodeInformation m_nodeInformation = null;
    private boolean m_bDirty = false;
    private int m_maxRowsDisplayed = 50;

    public VWWorkflowManagerItemPane(VWSession vwSession) {
        try {
            this.m_vwSession = vwSession;
            this.m_itemListenerList = new EventListenerList();
            this.m_folderOpenListenerList = new EventListenerList();
            this.m_contentsTable = new VWTable();
            this.m_contentsTable.setShowGrid(false);
            this.m_contentsTable.getSelectionModel().setSelectionMode(0);
            this.m_contentsTable.setDefaultRenderer(VWFolder.class, new VWIconCellRenderer());
            this.m_contentsTable.setDefaultRenderer(Icon.class, new VWIconCellRenderer());
            this.m_contentsTable.addMouseListener(new VWMouseAdapter(this));
            this.m_contentsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_contentsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.setLayout(new BorderLayout());
            this.m_scrollPane = new JScrollPane(this.m_contentsTable);
            this.add(this.m_scrollPane);
            this.m_contentsTable.getSelectionModel().addListSelectionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addItemSelectionListener(IVWItemSelectionListener listener) {
        this.m_itemListenerList.add(IVWItemSelectionListener.class, listener);
    }

    public void removeItemSelectionListener(IVWItemSelectionListener listener) {
        this.m_itemListenerList.remove(IVWItemSelectionListener.class, listener);
    }

    public void addFolderOpenListener(IVWFolderOpenListener listener) {
        this.m_folderOpenListenerList.add(IVWFolderOpenListener.class, listener);
    }

    public void removeFolderOpenListener(IVWFolderOpenListener listener) {
        this.m_folderOpenListenerList.remove(IVWFolderOpenListener.class, listener);
    }

    public void openSelectedItem() {
        try {
            if (this.m_contentsTable == null) {
                return;
            }
            TableModel tableModel = this.m_contentsTable.getModel();
            if (tableModel == null) {
                return;
            }
            if (tableModel instanceof IVWTableOperation) {
                ((IVWTableOperation)((Object)tableModel)).openItem(this.m_contentsTable.getSelectedRow());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteSelectedItem() {
        try {
            int nSelectedRow;
            if (this.m_contentsTable == null) {
                return;
            }
            TableModel tableModel = this.m_contentsTable.getModel();
            if (tableModel == null) {
                return;
            }
            if (tableModel instanceof VWQueueTableModel && (nSelectedRow = this.m_contentsTable.getSelectedRow()) != -1) {
                ((VWQueueTableModel)tableModel).deleteItem(nSelectedRow);
                int nRowCount = this.m_contentsTable.getRowCount();
                if (nRowCount > 0) {
                    if (nSelectedRow > nRowCount - 1) {
                        this.m_contentsTable.setRowSelectionInterval(nRowCount - 1, nRowCount - 1);
                    } else {
                        this.m_contentsTable.setRowSelectionInterval(nSelectedRow, nSelectedRow);
                    }
                } else {
                    this.fireSelectionChanged(new VWItemSelectionEvent(this, this.m_modelType, -1));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean refresh() {
        if (this.m_contentsTable == null) {
            return false;
        }
        TableModel tableModel = this.m_contentsTable.getModel();
        if (tableModel == null) {
            return false;
        }
        if (tableModel instanceof IVWTableOperation) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
            ((IVWTableOperation)((Object)tableModel)).refresh();
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (tableModel instanceof IVWChunkableQuery) {
            return ((IVWChunkableQuery)((Object)tableModel)).getCanPerformNext();
        }
        return false;
    }

    public boolean performNext() {
        if (this.m_contentsTable == null) {
            return false;
        }
        TableModel tableModel = this.m_contentsTable.getModel();
        if (tableModel == null) {
            return false;
        }
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        if (tableModel instanceof IVWChunkableQuery) {
            ((IVWChunkableQuery)((Object)tableModel)).performNext();
        }
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        if (tableModel instanceof IVWChunkableQuery) {
            return ((IVWChunkableQuery)((Object)tableModel)).getCanPerformNext();
        }
        return false;
    }

    public boolean getCanPerformNext() {
        if (this.m_contentsTable == null) {
            return false;
        }
        TableModel tableModel = this.m_contentsTable.getModel();
        if (tableModel == null) {
            return false;
        }
        if (tableModel instanceof IVWChunkableQuery) {
            return ((IVWChunkableQuery)((Object)tableModel)).getCanPerformNext();
        }
        return false;
    }

    public void setMaxRowsDisplay(int maxRows) {
        this.m_maxRowsDisplayed = maxRows;
        if (this.m_contentsTable == null) {
            return;
        }
        TableModel tableModel = this.m_contentsTable.getModel();
        if (tableModel == null) {
            return;
        }
        if (tableModel instanceof IVWChunkableQuery) {
            ((IVWChunkableQuery)((Object)tableModel)).setMaxRowsDisplayed(maxRows);
        }
    }

    public int getMaxRowsDisplay() {
        if (this.m_contentsTable == null) {
            return 0;
        }
        TableModel tableModel = this.m_contentsTable.getModel();
        if (tableModel == null) {
            return 0;
        }
        if (tableModel instanceof IVWChunkableQuery) {
            return ((IVWChunkableQuery)((Object)tableModel)).getMaxRowsDisplayed();
        }
        return 0;
    }

    public void setParentApplet(JApplet parentApplet) {
        this.m_parentApplet = parentApplet;
    }

    public void setParentContainer(Container parentContainer) {
        this.m_parentContainer = parentContainer;
    }

    public int getQueryResultsCount() {
        TableModel itemTableModel = this.m_contentsTable.getModel();
        if (itemTableModel instanceof IVWChunkableQuery) {
            return ((IVWChunkableQuery)((Object)itemTableModel)).getQueryResultsCount();
        }
        return 0;
    }

    public boolean getHasElements() {
        TableModel itemTableModel = this.m_contentsTable.getModel();
        if (itemTableModel instanceof IVWChunkableQuery) {
            return ((IVWChunkableQuery)((Object)itemTableModel)).getHasElements();
        }
        return false;
    }

    public void selectionChanged(VWFolderSelectionEvent event) {
        if (this.m_contentsTable == null) {
            return;
        }
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_modelType != 2) {
            this.m_modelType = 2;
            this.m_contentsTable.getModel().removeTableModelListener(this);
        }
        this.m_contentsTable.setModel(new VWFolderTableModel(event.getFolderNodes()));
        ((VWFolderTableModel)this.m_contentsTable.getModel()).addFolderOpenListener(this);
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void selectionChanged(VWQueueSelectionEvent event) {
        if (this.m_contentsTable == null) {
            return;
        }
        this.m_nodeInformation = event.getNodeInformation();
        if (event.getUpdateItemPane()) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_modelType == 2) {
                ((VWFolderTableModel)this.m_contentsTable.getModel()).removeFolderOpenListener(this);
            }
            this.m_contentsTable.setModel(new VWQueueTableModel(event.getNodeInformation(), this.m_vwSession, this.m_parentContainer, this.m_parentApplet));
            this.resizeColumns();
            if (this.m_modelType != 1) {
                this.m_modelType = 1;
                this.m_contentsTable.getModel().addTableModelListener(this);
            }
            if (this.m_contentsTable.getModel() instanceof IVWChunkableQuery) {
                ((IVWChunkableQuery)((Object)this.m_contentsTable.getModel())).setMaxRowsDisplayed(this.m_maxRowsDisplayed);
            }
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.m_bDirty = true;
        }
    }

    public void selectionChanged(VWMilestonesSelectionEvent event) {
        if (this.m_contentsTable == null) {
            return;
        }
        this.m_nodeInformation = event.getNodeInformation();
        if (event.getUpdateItemPane()) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_modelType == 2) {
                ((VWFolderTableModel)this.m_contentsTable.getModel()).removeFolderOpenListener(this);
            }
            this.m_contentsTable.setModel(new VWMilestonesTableModel(this.m_vwSession, this.m_parentContainer, this.m_parentApplet));
            this.resizeColumns();
            if (this.m_modelType != 3) {
                this.m_modelType = 3;
                this.m_contentsTable.getModel().addTableModelListener(this);
            }
            if (this.m_contentsTable.getModel() instanceof IVWChunkableQuery) {
                ((IVWChunkableQuery)((Object)this.m_contentsTable.getModel())).setMaxRowsDisplayed(this.m_maxRowsDisplayed);
            }
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.m_bDirty = true;
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (this.m_contentsTable == null) {
                return;
            }
            TableModel tableModel = this.m_contentsTable.getModel();
            if (tableModel == null) {
                return;
            }
            if (tableModel instanceof IVWTableOperation) {
                int nSelectedRow = this.m_contentsTable.getSelectedRow();
                this.fireSelectionChanged(new VWItemSelectionEvent(this, this.m_modelType, nSelectedRow));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        try {
            if (this.m_contentsTable == null) {
                return;
            }
            Point pt = event.getPoint();
            int nRowIndex = this.m_contentsTable.rowAtPoint(pt);
            int nColumnIndex = this.m_contentsTable.columnAtPoint(pt);
            if (nRowIndex == -1 || nColumnIndex == -1) {
                return;
            }
            TableModel tableModel = this.m_contentsTable.getModel();
            if (tableModel == null) {
                return;
            }
            if (tableModel instanceof IVWTableOperation) {
                ((IVWTableOperation)((Object)tableModel)).openItem(nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createPopup(MouseEvent event) {
    }

    public void searchCriteriaChanged(VWPerformSearchEvent event) {
        if (this.m_contentsTable == null) {
            return;
        }
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_bDirty) {
            if (this.m_modelType == 2) {
                ((VWFolderTableModel)this.m_contentsTable.getModel()).removeFolderOpenListener(this);
            }
            this.m_contentsTable.setModel(new VWQueueTableModel(this.m_nodeInformation, this.m_vwSession, this.m_parentContainer, event));
            if (this.m_modelType != 1) {
                this.m_modelType = 1;
                this.m_contentsTable.getModel().addTableModelListener(this);
            }
            this.m_bDirty = false;
        } else {
            TableModel vwTableModel = this.m_contentsTable.getModel();
            if (vwTableModel instanceof IVWDefinableQuery) {
                IVWDefinableQuery vwQueryTable = (IVWDefinableQuery)((Object)vwTableModel);
                vwQueryTable.setQueryIndexName(event.getIndexName());
                vwQueryTable.setQueryMinIndexValue(event.getMinValues());
                vwQueryTable.setQueryMaxIndexValue(event.getMaxValues());
                vwQueryTable.setQueryIndexFlags(event.getIndexFlags());
                vwQueryTable.setQueryFilter(event.getFilterString());
                vwQueryTable.setSelectedColumns(event.getColumnNames());
            }
        }
        this.resizeColumns();
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void folderOpened(VWFolderOpenEvent event) {
        this.fireFolderOpened(event);
    }

    public void tableChanged(TableModelEvent event) {
    }

    private void fireSelectionChanged(VWItemSelectionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_itemListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWItemSelectionListener.class) continue;
            ((IVWItemSelectionListener)listeners[i + 1]).selectionChanged(event);
        }
    }

    private void fireFolderOpened(VWFolderOpenEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_folderOpenListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWFolderOpenListener.class) continue;
            ((IVWFolderOpenListener)listeners[i + 1]).folderOpened(event);
        }
    }

    private void resizeColumns() {
        if (this.m_contentsTable == null) {
            return;
        }
        TableColumnModel columnModel = this.m_contentsTable.getColumnModel();
        int numColumns = this.m_contentsTable.getColumnCount();
        int remainingWidth = this.m_scrollPane.getViewport().getWidth();
        for (int i = 0; i < numColumns; ++i) {
            Class<?> colClass = this.m_contentsTable.getColumnClass(i);
            TableColumn column = columnModel.getColumn(i);
            int newColWidth = 0;
            if (colClass == Icon.class) {
                column.setMinWidth(25);
                column.setMaxWidth(25);
                newColWidth = 25;
                if (i == 0 && this.m_nodeInformation.getOverdueExposed()) {
                    if (VWStringUtils.compare(this.m_nodeInformation.getName(), VWResource.s_milestoneTracking) != 0) {
                        column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("bwoverdue.gif"), VWResource.s_deadlineStatus));
                    } else {
                        column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("blank.gif"), VWResource.s_deadlineStatus));
                    }
                } else if (i == 1 && this.m_nodeInformation.getOverdueExposed() || !this.m_nodeInformation.getOverdueExposed() && i == 0) {
                    if (this.m_nodeInformation.isTrackerQueue()) {
                        column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("bwtracker.gif"), VWResource.s_itemType));
                    } else if (this.m_nodeInformation.getType() == 4) {
                        column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("bwmilestone.gif"), VWResource.s_itemType));
                    } else {
                        column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("bwstep.gif"), VWResource.s_itemType));
                    }
                } else {
                    column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("bwlock.gif"), VWResource.s_lockStatus));
                }
            } else {
                column.setHeaderRenderer(new VWTableHeaderRenderer((String)column.getHeaderValue()));
                this.m_contentsTable.sizeColumnWidthToFit(column);
                newColWidth = column.getWidth() + 15;
                column.setMinWidth(10);
                if (remainingWidth > 0 && remainingWidth / (numColumns - i) > newColWidth) {
                    newColWidth = remainingWidth / (numColumns - i);
                }
            }
            if (i == numColumns - 1 && remainingWidth > 0) {
                column.setWidth(remainingWidth);
            } else {
                column.setWidth(newColWidth);
            }
            column.setPreferredWidth(column.getWidth());
            remainingWidth -= newColWidth;
        }
    }
}

